
local GameRain = class("GameRain", function()
    local node = cc.Node:create()
    return node
end)
function GameRain:ctor()
   
end
function GameRain:onEnter()

end
function GameRain.create(isBig)
    local gameControl=GameRain.new()

    local function onNodeEvent(event)
        if "enter" == event then
            gameControl:onEnter()

        elseif "exit" == event then
            gameControl:onExit()
        end
    end
    gameControl:registerScriptHandler(onNodeEvent)
    gameControl:initWithLayer(isBig)
    return gameControl
end
function GameRain:onEnter()

end
function GameRain:onExit()

end


function GameRain:initWithLayer(isBig)
    local layer=cc.Layer:create()
    self:addChild(layer)

    for i=1,3 do
        local str=string.format("blackcloud_%d.png",i)
        local sprite=cc.Sprite:create(str)
        layer:addChild(sprite)
        sprite:setPosition(display.size.width/2-(1-i)*80,display.size.height+sprite:getContentSize().height/2)

    end

    local move=cc.MoveBy:create(3,cc.p(0,-100))
    local function callback()
        local num=500
        if isBig==false then
            --todo
            num=100
        end
        for i=1,num do
            local zhengfu=math.random()
            if zhengfu>=0.5 then
                --todo
                zhengfu=1
            else
                zhengfu=-1
            end
            local rain=cc.Sprite:create("smallrain.png")
            rain:setPosition(display.size.width/2+zhengfu*math.random()*200
                ,display.size.height+rain:getContentSize().height/2+zhengfu*math.random()*40+40)


            self:addChild(rain,-1)
            local move=cc.MoveBy:create(math.random()*10+10,cc.p(0,-display.size.height))

            if isBig==false then
                move=cc.MoveBy:create(math.random()*5+4,cc.p(0,-display.size.height))
            end
            
            local del=cc.DelayTime:create(math.random()*10)
            rain:runAction(cc.Sequence:create(del,move,cc.RemoveSelf:create()))
        end
    end

    local function callback2()
       layer:removeFromParent()
    end
    local call=cc.CallFunc:create(callback)

    local call2=cc.CallFunc:create(callback2)
    local del=cc.DelayTime:create(20)
    if isBig==false then
        --todo
        del=cc.DelayTime:create(10)
    end
    
    local seq=cc.Sequence:create(move,call,del,move:reverse(),call2)
    layer:runAction(seq)
end


return GameRain

